<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


// Auth::routes();
Route::get('/', function () {
    return view('welcome');
});


// Admin Routes

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
// Route::get('/admin/profile', [App\Http\Controllers\Admin\DashboardController::class, 'profile'])->name('admin.profile');
// Route::post('/admin/update', [App\Http\Controllers\Admin\DashboardController::class, 'updateProfile'])->name('admin.profile.update');
// End Admin Routes

// Admin Routes
Route::prefix('admin')->name('admin.')->middleware('auth:admin')->group(function () {
    // Authentication Routes
    Route::get('dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/', [App\Http\Controllers\Auth\LoginController::class, 'showAdminLoginForm'])->name('login-view');
    Route::post('/', [App\Http\Controllers\Auth\LoginController::class, 'adminLogin'])->name('login');
    Route::get('/register', [App\Http\Controllers\Auth\RegisterController::class, 'showAdminRegisterForm'])->name('register-view');
    Route::post('/register', [App\Http\Controllers\Auth\RegisterController::class, 'createAdmin'])->name('register');

    // Admin Dashboard
    Route::get('profile', [App\Http\Controllers\Admin\DashboardController::class, 'profile'])->name('profile');
    Route::post('update', [App\Http\Controllers\Admin\DashboardController::class, 'updateProfile'])->name('profile.update');


    // Advertisement Routes
    Route::resource('advertisements', App\Http\Controllers\Admin\AdvertisementController::class);
    Route::get('advertisements/data/fetch', [App\Http\Controllers\Admin\AdvertisementController::class, 'getAdData'])->name('advertisements.fetchdata');
    Route::post('advertisements/image/upload', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdImageUpload'])->name('advertisement-image-upload');
    Route::delete('advertisements/image/delete', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdImageDelete'])->name('advertisement-image-delete');
    Route::post('ad-position-check', [App\Http\Controllers\Admin\AdvertisementController::class, 'AdPositionCheck'])->name('ad-position-check');
    
    // CMS Pages
    Route::get('cms/pages', [App\Http\Controllers\Admin\CMSController::class, 'index'])->name('pages.create');
    Route::post('cms/page/store', [App\Http\Controllers\Admin\CMSController::class, 'store'])->name('pages.store');
    Route::put('cms/page/update', [App\Http\Controllers\Admin\CMSController::class, 'store'])->name('pages.update');

    // Contact Routes
    Route::get('enquiry-list', [App\Http\Controllers\Admin\ContactController::class, 'index'])->name('enquiry-list');
    Route::get('enquiry/data', [App\Http\Controllers\Admin\ContactController::class, 'getData'])->name('enquiry.data');
    Route::get('contact-info', [App\Http\Controllers\Admin\ContactController::class, 'contact_widget'])->name('contact.widget');
    Route::post('contact-info', [App\Http\Controllers\Admin\ContactController::class, 'storeWidget'])->name('contact-widget.store');
    Route::put('contact-info/{id}', [App\Http\Controllers\Admin\ContactController::class, 'updateWidget'])->name('contact-widget.update');
    Route::get('/contacts/{id}', [App\Http\Controllers\Admin\ContactController::class, 'show'])->name('contacts.show');
    Route::delete('/contacts/{id}', [App\Http\Controllers\Admin\ContactController::class, 'destroy'])->name('contacts.destroy');


});

Auth::routes(['verify' => true]);

// Front End Routes
Route::prefix('user')->name('user.')->middleware('auth')->group(function ()  {
    // Other user routes
    Route::get('/login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::get('/my-account', [App\Http\Controllers\Front\UserController::class, 'index'])->name('my-account');
    Route::resource('contact-us', App\Http\Controllers\User\ContactController::class);   
    Route::get('cms-pages', [App\Http\Controllers\User\ContactController::class,'CMSPages'])->name('cms.pages')->withoutMiddleware('auth');

    // Route::get('/dashboard', [App\Http\Controllers\User\DashboardController::class, 'index'])->name('dashboard');
    // Route::get('/profile', [App\Http\Controllers\User\ProfileController::class, 'index'])->name('profile');
    // ...
});



// // Front End Routes
// Route::resource('contact-us', App\Http\Controllers\ContactController::class);
// Route::get('cms-pages', [App\Http\Controllers\ContactController::class,'CMSPages'])->name('cms.pages');

// // End Front Routes


// Route::get('/admin',[App\Http\Controllers\Auth\LoginController::class,'showAdminLoginForm'])->name('admin.login-view');
// Route::post('/admin',[App\Http\Controllers\Auth\LoginController::class,'adminLogin'])->name('admin.login');

// Route::get('/admin/register',[App\Http\Controllers\Auth\RegisterController::class,'showAdminRegisterForm'])->name('admin.register-view');
// Route::post('/admin/register',[App\Http\Controllers\Auth\RegisterController::class,'createAdmin'])->name('admin.register');

// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
// Route::get('/admin/dashboard',function(){
//     return view('admin.dashboard');
// })->middleware('auth:admin');

